<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class ProductsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('admin.views.product.index');
    }

    public function list()
    {
        $products = Product::with('user')->paginate('5');
        return view('admin.views.product.list',compact('products'));

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
//        return $request->all();
        $product = new Product();
        $product->name =$request->name;
        $product->qty =$request->qty;
        $product->price =$request->price;
        $product->user_id= Auth::id();
        $product->save();
        Session::flash('success','محصول جدید با موفقیت ثبت نام شد');
        return redirect('/product');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $product = Product::where('id',$id)->first();
        return view('admin.views.product.update',compact('product'));

    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {

        $product = Product::findOrFail($id);
        $product->name =$request->name;
        $product->qty =$request->qty;
        $product->price =$request->price;
        $product->save();
        Session::flash('success','محصول جدید با موفقیت ویرایش شد');
        return redirect('/productList');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
       $product = Product::findOrFail($id);
       $product->delete();
        Session::flash('success','محصول با موفقیت حذف شد');
        return redirect('/productList');


    }
}
